unit fROR_HEPC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fROR_GenericRegistry, Menus, ActnList, ImgList, StdCtrls,
  ComCtrls, ExtCtrls, Buttons, ToolWin, fROR_VistARegistries, ovcfiler,
  ovcstore, uROR_VistAStore, ovcbase, ovcstate, uROR_ListView,
  uROR_Selector, uROR_CustomControls, uROR_CustomListView, HTMLLite,
  uROR_GridView, AdvMenus, uROR_SearchEdit, uROR_Errors, AdvMenuStylers,
  VA508AccessibilityManager;

type
  TFormHEPC = class(TFormGenericRegistry)

    mnuPatients: TAdvPopupMenu;
    Edit1: TMenuItem;
    N4: TMenuItem;
    Delete1: TMenuItem;
    OvcComponentState: TOvcComponentState;

    procedure acEditPatientDataExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure lsvPatientsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure acHelpTopicsExecute(Sender: TObject);

  protected

    function  GetLayoutSectionName: String; override;

  public
  
    constructor CreateRegistry(aRegInfo: TRegistryInfo; anOwner: TComponent = nil); override;

  end;

implementation
{$R *.dfm}

uses
  fROR_HEPCPatientEdit, uROR_HEPCPatientData, uROR_Common, uROR_Broker, fROR_Main;

var
  FormHEPCPatientEdit: TFormHEPCPatientEdit;

//////////////////////////////////// TFormHEPC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TFormHEPC.CreateRegistry(aRegInfo: TRegistryInfo; anOwner: TComponent);
begin
  inherited CreateRegistry(aRegInfo, anOwner);

  if Assigned(RegInfo) then
    begin
      RegInfo.InvestDrugClasses.Add('IN140');
      ActivePatientData := THEPCPatientData.Create(RegInfo.IEN);
      LoadLayout;
    end;
end;

procedure TFormHEPC.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveLayout;
  inherited;
end;

function TFormHEPC.GetLayoutSectionName: String;
begin
  if Assigned(OvcComponentState) then
    Result := OvcComponentState.Section
  else
    Result := inherited GetLayoutSectionName;
end;

/////////////////////////////////// Registry \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFormHEPC.acEditPatientDataExecute(Sender: TObject);
var
  edRC: TReturnCode;
begin
  edRC := RC_OK;
  if not Assigned(FormHEPCPatientEdit) then
    FormHEPCPatientEdit := TFormHEPCPatientEdit.Create(RegInfo);
  if SetPatientContext then
    begin
      StartPatientEdit;
      try
        edRC := FormHEPCPatientEdit.Edit(ActivePatientData, PtIEN);
        inherited;
      finally
        EndPatientEdit;
      end;
    end;
  if edRC = RC_DELETE then
    acDeletePatient.Execute;
end;

procedure TFormHEPC.acHelpTopicsExecute(Sender: TObject);
begin
  inherited;
  Application.HelpCommand(HELP_INDEX, 0);
end;

procedure TFormHEPC.lsvPatientsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_Return then acEditPatientData.Execute;
end;

end.
